import React from 'react';
import { TipButton } from 'modules/categorization/components/TipButton';
import Select from 'components/Select';
import Icon from 'lego/components/Icon';
import css from './Category.scss';

interface Props {
  name?: string;
  searchRange?: number[];
  tags?: any[];
  top?: boolean;
  tipUrl?: string;
}

const Category = (props: Props) => {
  const { name, searchRange, tags, top, tipUrl } = props;

  return (
    <span>
      <Select value={name} range={searchRange} />
      {top && <Icon pack={Icon.PACKS.MATERIAL} icon="star" className={css.b__top} />}
      &nbsp;
      {tipUrl && <TipButton url={tipUrl} />}
      &nbsp;
      {Array.isArray(tags) && tags.length ? (
        <span className={css.b__tags}>
          {tags.map((tag, index) => (
            <React.Fragment key={tag.id || index}>
              #<Select value={tag.name} range={tag.searchRange} />
              &nbsp;
            </React.Fragment>
          ))}
        </span>
      ) : null}
    </span>
  );
};

Category.defaultProps = {
  searchRange: undefined,
  tags: undefined,
  top: false,
};

export default Category;
