export interface Column {
  id: number;
  name: string;
}

export type Rights = Record<
  number | string,
  {
    id: number;
    value: boolean;
  }
>;

export interface Row {
  id: number;
  name: string;
  rights: Rights;
}

export interface SingleRight {
  id: number;
  name: string;
  value: boolean;
}

export type Values = Record<number | string, Record<number | string, boolean>>;

export interface RightsScheme {
  columns: Column[];
  rows: Row[];
  singleRights: SingleRight[];
  values: Values;
}

export interface CategoryRightsProps {
  input: {
    value?: RightsScheme;
    name: string;
  };
  meta: {
    initial?: RightsScheme;
  };
}
