import React, { FC } from 'react';
import LegoCheckbox from '@crm/components/dist/lego2/Checkbox';
import { CheckboxProps } from './Checkbox.types';

export const Checkbox: FC<CheckboxProps> = ({ value, rowId, columnId, onChange }) => {
  const handleChange = (val: boolean) => {
    onChange(rowId, Number(columnId), val);
  };

  return <LegoCheckbox checked={value} onChange={handleChange} />;
};
