import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { Checkbox } from './Checkbox';
import { RowProps } from './Row.types';

export const Row: FC<RowProps> = observer((props) => {
  const { values = {}, name, onChange, id, columns } = props;

  return (
    <>
      <div>{name}</div>
      {columns.map((column) => (
        <Checkbox
          key={column.id}
          rowId={id}
          columnId={column.id}
          value={Boolean(values[column.id])}
          onChange={onChange}
        />
      ))}
    </>
  );
});
