import { makeObservable, observable, action } from 'mobx';
import cloneDeep from 'lodash/cloneDeep';
import { Values } from './CategoryRights.types';

export class ValuesStore {
  public constructor() {
    makeObservable(this, {
      initialValues: observable,
      values: observable,
      change: action.bound,
      setInitialValue: action.bound,
    });
  }

  public setInitialValue(values: Values) {
    this.initialValues = values;
    this.values = cloneDeep(this.initialValues);
  }

  public initialValues: Record<number, Record<number, boolean>> = {};

  public values: Record<number | string, Record<number, boolean>> = {};

  public change(rowId: number | string, columnId: number, value: boolean) {
    this.values[rowId][columnId] = value;
  }
}
