import { RightsScheme, Values } from './CategoryRights.types';

export const adaptToInitialValues = (
  categoryRights: RightsScheme | undefined,
): RightsScheme | undefined => {
  if (!categoryRights) {
    return undefined;
  }

  const { rows = [] } = categoryRights;
  const values: Values = rows.reduce((acc, row) => {
    const values = Object.keys(row.rights).reduce(
      (rightAcc, id) => ({
        ...rightAcc,
        [id]: row.rights[id].value,
      }),
      {},
    );

    return {
      ...acc,
      [row.id]: values,
    };
  }, {});

  return {
    ...categoryRights,
    values,
  };
};
