import { RightsScheme, Row } from './CategoryRights.types';

export const adaptToSave = (categoryRights: RightsScheme | undefined): RightsScheme | undefined => {
  if (!categoryRights) {
    return undefined;
  }

  const result: RightsScheme = { ...categoryRights };

  if (categoryRights) {
    Object.keys(categoryRights.values).forEach((rowId) => {
      const row = result.rows.find((row) => row.id === Number(rowId)) as Row;
      const rightsValues = categoryRights.values[rowId];
      Object.keys(rightsValues).forEach((columnId) => {
        row.rights[columnId].value = rightsValues[columnId];
      });
    });
  }

  return result;
};
