import React from 'react';
import { connect } from 'react-redux';
import { history } from 'appHistory';
import { triggerUpdate } from 'containers/TreeSelect/actions';
import Categories from '../Categories';
import Form from '../Form';
import css from './Layout.scss';
import { CATEGORY_TREE_NAME } from '../../constants';

const LayoutCategory = props => {
  const { isNew, id, query, onSubmitSuccess, onClone, ...passPropsThrough } = props;

  return (
    <div className={css.b}>
      <Categories
        {...passPropsThrough}
        enableReinitialize
        selected={id || null}
        className={css.b__categories}
      />
      {(isNew || id) && (
        <Form
          className={css.b__form}
          isNew={isNew}
          id={id}
          query={query}
          onSubmitSuccess={onSubmitSuccess}
          onClone={onClone}
        />
      )}
    </div>
  );
};

const actions = (dispatch, props) => ({
  onSubmitSuccess: () => dispatch(triggerUpdate(CATEGORY_TREE_NAME)),
  onClick: id => history.push(`/admin/categories/${id}`),
  onClone: () => history.push(`/admin/categories/new?id=${props.id}`),
});

export default connect(null, actions)(LayoutCategory);
