/*
eslint-disable
no-param-reassign
*/

import { get, jsonApiCall } from 'api/common';
import { push } from 'modules/notificationsUI/actions';

const formatBackendScheme = data => {
  try {
    data.metadata.queues = data.metadata.queues.map(item => {
      item.subName = item.code;
      return item;
    });

    return data;
  } catch (e) {
    return data;
  }
};

export default actionTypes => ({
  load: (data = {}) => dispatch => {
    const url = data.isNew ? '/view/support/category/new' : '/view/support/category';
    const sendData = data.isNew ? data.query : { id: data.id };

    dispatch({ type: actionTypes.LOAD_REQUEST });
    return get({ url, data: sendData })
      .then(payload => {
        payload = formatBackendScheme(payload);
        dispatch({ type: actionTypes.LOAD_RECEIVE, payload });
        return payload;
      })
      .catch(e => {
        dispatch({ type: actionTypes.LOAD_FAIL });
        throw e;
      });
  },
  save: data => dispatch => {
    dispatch({ type: actionTypes.SAVE.REQUEST });
    return jsonApiCall({ url: '/action/support/category/save', data }).then(payload => {
      payload = formatBackendScheme(payload);
      dispatch(push({ theme: 'success', text: 'Категория сохранена' }));
      dispatch({ type: actionTypes.SAVE.RECEIVE, payload });
      return payload;
    });
  },
});
