import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';

export default actionTypes => {
  const behaviors = {
    [actionTypes.LOAD_REQUEST](state) {
      return {
        ...state,
        isFetch: true,
      };
    },
    [actionTypes.LOAD_RECEIVE](state, { payload }) {
      return {
        ...state,
        data: payload,
        isFetch: false,
        isLoad: true,
      };
    },
    [actionTypes.LOAD_FAIL](state) {
      return {
        ...state,
        isFetch: false,
        isLoad: false,
      };
    },
    [actionTypes.SAVE.RECEIVE](state, { payload }) {
      return {
        ...state,
        data: payload,
      };
    },
  };

  return reducerFactoryRaw(actionTypes, behaviors);
};
