import createActionTypes from './createActionTypes';
import createActions from './createActions';
import createReducer from './createReducer';
import createSelectors from './createSelectors';

const createRedux = path => {
  if (createRedux.redux) {
    return createRedux.redux;
  }

  const patchedActionTypes = createActionTypes(path);

  const result = {
    actionTypes: patchedActionTypes,
    actions: createActions(patchedActionTypes),
    reducer: createReducer(patchedActionTypes),
    selectors: createSelectors(path),
  };

  window.reduxStore.injectReducer(path, result.reducer);

  createRedux.redux = result;
  return result;
};

export default createRedux;
