import React from 'react';
import url from 'utils/url';
import TitleChain from 'modules/heading';
import Layout from './components/Layout';

const CategoryRouter = props => {
  const { id } = props.match.params;
  const isNew = id === 'new';
  const parsedId = parseInt(id, 10) || null;
  const query = url.queryToObject(props.location.search);

  return (
    <React.Fragment>
      <TitleChain>Категории</TitleChain>
      <Layout isNew={isNew} id={parsedId} query={query} {...props} />
    </React.Fragment>
  );
};

export default CategoryRouter;
