import React, { Component, ReactNode, CSSProperties } from 'react';
import css from './Toolbar.module.css';
import { ToolbarProps } from './Toolbar.types';

class Toolbar extends Component<ToolbarProps> {
  public static defaultProps: ToolbarProps = {
    position: 'bottom',
  };

  private createPositionStyles = (): CSSProperties => {
    const { position } = this.props;

    let styles: CSSProperties = {
      left: '0',
    };

    if (position === 'top') {
      styles.top = '0';
    }

    if (position === 'bottom') {
      styles.bottom = '0';
    }

    return styles;
  };

  public render(): ReactNode {
    const style: CSSProperties = this.createPositionStyles();

    return (
      <div className={css.Toolbar} style={style}>
        {this.props.children}
      </div>
    );
  }
}

export default Toolbar;
