import React, { PureComponent, ReactNode } from 'react';
import { Field } from 'react-final-form';
import Checkbox from 'lego/final-form/CheckBox';
import Select from 'lego/final-form/Select';
import { QueueOptionProps } from './QueueOption.types';
import css from './QueueOption.module.css';
import QueueName from './QueueName';

class QueueOption extends PureComponent<QueueOptionProps> {
  public render(): ReactNode {
    const { style, name, communicationTypes } = this.props;

    return (
      <div className={css.QueueOption} style={style}>
        <Field name={`${name}.queueName`} render={QueueName} />
        <div className={css.QueueOption__controls}>
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.issueCategoryRequired`}
            label="Обращение"
            disabled
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.outcomingCallCategoryRequired`}
            label="Исходящие звонки"
            disabled
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.outcomingMailCategoryRequired`}
            label="Исходящие письма"
            disabled
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.incomingCallCategoryRequired`}
            label="Входящие звонки"
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.incomingMailCategoryRequired`}
            label="Входящие письма"
            checked={false}
          />
        </div>

        <div className={css.QueueOption__controls}>
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.issueCategoryVisible`}
            label="Обращение"
            disabled
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.outgoingCallCategoryVisible`}
            label="Исходящие звонки"
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.outgoingMailCategoryVisible`}
            label="Исходящие письма"
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.incomingCallCategoryVisible`}
            label="Входящие звонки"
          />
          <Field
            className={css.QueueOption__checkbox}
            component={Checkbox}
            name={`${name}.incomingMailCategoryVisible`}
            label="Входящие письма"
            checked={false}
          />
        </div>

        <div className={css.QueueOption__controls}>
          <Field
            className={css.QueueOption__communicationType}
            name={`${name}.communicationType`}
            component={Select}
            castTo={Number}
            hasEmptyValue={false}
            options={communicationTypes}
          />
        </div>
      </div>
    );
  }
}

export default QueueOption;
