export interface QueueOption {
  queueId: number; // идентификатор очереди
  queueName: string; // название очереди
  queueCode: string; // код очереди
  issueCategoryRequired: boolean; // обязательно ли проставлять категорию для обращения целиком
  outgoingMailCategoryRequired: boolean; // обязательно ли проставлять категории для исходящих писем
  incomingMailCategoryRequired: boolean; // обязательно ли проставлять категории для входящих писем
  outgoingCallCategoryRequired: boolean; // обязательно ли проставлять категории для исходящих звонков
  incomingCallCategoryRequired: boolean; // обязательно ли проставлять категории для входящих звонков
  issueCategoryVisible: boolean;
  outgoingMailCategoryVisible: boolean;
  incomingMailCategoryVisible: boolean;
  outgoingCallCategoryVisible: boolean;
  incomingCallCategoryVisible: boolean;
  communicationType: number;
}

export type QueueMap = Record<string, QueueOption>;

export interface FormValues {
  queueOptionMap: QueueMap;
}
