import memoize from 'memoize-one';
import { QueueOption, QueueMap } from './types';

export const createQueueIdKey = (queueId: number): string => {
  return `queueId:${queueId}`;
};

export const getQueueOptionList = memoize(
  (queueIdList: number[], queueIdMap: QueueMap): QueueOption[] => {
    return queueIdList.map((queueId) => queueIdMap[createQueueIdKey(queueId)]);
  },
);
