import React, { memo } from 'react';
import cx from 'classnames';
import RadioButton from '@crm/components/dist/lego2/RadioButton';
import css from './FallbackToggle.module.css';
import { FallbackToggleProps } from './FallbackToggle.types';
import { withChangeHandler } from './withChangeHandler';
import { FallbackValueType } from '../../types';

const fallbackToggleOptions = [
  { value: FallbackValueType.Off, children: 'Выключен' },
  { value: FallbackValueType.On, children: 'Включен' },
];

const FallbackToggle = memo<FallbackToggleProps>((props) => {
  const { onChange, service } = props;

  return (
    <div className={cx(css.FallbackToggle, props.className)}>
      <div className={css.FallbackToggle__service}>{service.name}</div>
      <RadioButton
        className={css.FallbackToggle__toggle}
        isEventValue={false}
        size="m"
        view="default"
        options={fallbackToggleOptions}
        onChange={onChange}
        value={props.value.toString()}
      />
    </div>
  );
});

export default withChangeHandler(FallbackToggle);
