import React, { useState, useCallback } from 'react';
import { setFallbacks } from '../../requests/setFallbacks';
import { SetFallbacksRequestBody } from '../../requests/setFallbacks.types';
import { FallbackValue, FallbackValueType } from '../../types';
import { FallbackValueImpl } from '../../models/FallbackValueImpl';

export const withChangeHandler = (FallbackToggle) => (props) => {
  const { service } = props;

  const [value, setValue] = useState<FallbackValue>(service.fallbackEnabled);
  const handleChange = useCallback(
    (fallbackValue: FallbackValueType) => {
      const prevValue = value;
      const nextValue = new FallbackValueImpl(fallbackValue);
      const requestBody: SetFallbacksRequestBody = {
        services: [
          {
            ...service,
            fallbackEnabled: nextValue,
          },
        ],
      };

      setValue(nextValue);
      setFallbacks(requestBody).catch(() => {
        setValue(prevValue);
      });
    },
    [value, service],
  );

  return <FallbackToggle {...props} value={value} onChange={handleChange} />;
};
