import React, { FC, useState, useEffect } from 'react';
import FallbackToggle from './FallbackToggle';
import css from './Layout.module.css';
import { ServiceFrontend } from '../types';
import { getFallbacks } from '../requests/getFallbacks';
import { FallbackValueImpl } from '../models/FallbackValueImpl';

const Layout: FC = () => {
  const [services, setServices] = useState<ServiceFrontend[]>([]);

  useEffect(() => {
    getFallbacks().then((response) => {
      setServices(
        response.services.map((item) => ({
          ...item,
          fallbackEnabled: new FallbackValueImpl(item.fallbackEnabled),
        })),
      );
    });
  }, []);

  return (
    <div className={css.Layout}>
      {services.map((service) => (
        <FallbackToggle className={css.Layout__fallback} key={service.id} service={service} />
      ))}
    </div>
  );
};

export default Layout;
