import { FallbackValue } from '../types';

export class FallbackValueImpl implements FallbackValue {
  public static readonly stringToBooleanMap = new Map([
    ['on', true],
    ['off', false],
  ]);

  public static readonly booleanToStringMap = new Map([
    [true, 'on'],
    [false, 'off'],
  ]);

  private _value: boolean;

  public constructor(value: 'on' | 'off' | boolean) {
    if (typeof value === 'string') {
      this._value = Boolean(FallbackValueImpl.stringToBooleanMap.get(value));
    } else {
      this._value = value;
    }
  }

  public toString() {
    return FallbackValueImpl.booleanToStringMap.get(this.value)!;
  }

  public toJSON() {
    return this._value;
  }

  public get value() {
    return this._value;
  }
}
