import * as React from 'react';
import { reduxForm, InjectedFormProps } from 'redux-form';
import { FormattedDate } from 'react-intl';
import Row from 'forms/Base/Row';
import Form from 'components/Form';
import Toolbar from 'components/Toolbar';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import constants from '../../constants';
import css from './Form.scss';

interface OwnProps {
  className?: string;
  data?: any;
  meta?: any;
}

type Props = OwnProps & InjectedFormProps;

const TemplateForm: React.FC<Props> = ({ handleSubmit, className, data, submitting, invalid }) => (
  <Form className={cx(className, css.b)} onSubmit={handleSubmit}>
    <div className={css.b__header}>
      <Toolbar inline>
        <Button view="action" type="submit" disabled={submitting || invalid}>
          Сохранить
        </Button>
      </Toolbar>
      {data.id && (
        <div className={css.b__meta}>
          <div className={css.b__field}>
            <span className={css.b__label}>id:</span>
            <span className={css.b__value}>{data.id}</span>
            &nbsp;
          </div>
          {data.modified_on && (
            <div className={css.b__field}>
              <span className={css.b__label}>Последнее изменение:</span>
              <span className={css.b__value}>
                {data.modified_by && (
                  <React.Fragment>
                    <span>{data.modified_by}</span>
                    ,&nbsp;
                  </React.Fragment>
                )}
                <FormattedDate
                  value={new Date(data.modified_on)}
                  year="numeric"
                  month="numeric"
                  day="numeric"
                  hour="numeric"
                  minute="numeric"
                />
              </span>
              &nbsp;
            </div>
          )}
          {data.created_on && (
            <div className={css.b__field}>
              <span className={css.b__label}>Создал:</span>
              <span className={css.b__value}>
                {data.created_by && (
                  <React.Fragment>
                    <span>{data.created_by}</span>
                    ,&nbsp;
                  </React.Fragment>
                )}
                <FormattedDate
                  value={new Date(data.created_on)}
                  year="numeric"
                  month="numeric"
                  day="numeric"
                  hour="numeric"
                  minute="numeric"
                />
              </span>
              &nbsp;
            </div>
          )}
        </div>
      )}
    </div>
    <div className={css.b__content}>
      <Row label="Название" component="TextInput" name="name" />
      <Row label="Enabled" component="TextInput" name="enabled" />
      <Row label="Next Export Dt" component="TextInput" name="next_export_dt" />
      <Row label="Replace Mask" component="TextInput" name="replace_mask" />
      <Row label="Table Url" component="TextInput" name="table_url" />
      <Row label="Repeat Interval" component="TextInput" name="repeat_interval" />
      <Row label="SQL" component="TextArea" name="sql" rows="20" />
    </div>
  </Form>
);

TemplateForm.defaultProps = {
  meta: {},
  initialValues: {},
};

export default reduxForm<{}, OwnProps>({ form: constants.name })(TemplateForm);
