/* eslint-disable @typescript-eslint/camelcase  */

import * as React from 'react';
import { connect } from 'react-redux';
import Form from './Form';
import redux from '../../redux';

interface ConnectedProps {
  id?: number | null;
  isNew?: boolean;
  className?: string;
}

interface ConnectedState {
  data: any;
}

interface ConnectedDispatch {
  post: (values: any) => any;
}

type Props = ConnectedProps & ConnectedState & ConnectedDispatch;

const newInitialData = {
  replace_mask: 'fielddate',
  repeat_interval: 'freq=minutely interval=60',
};

class FormContainer extends React.PureComponent<Props> {
  private onSubmit = data => {
    const sendData = {
      id: data.id,
      name: data.name,
      sql: data.sql,
      tableUrl: data.table_url,
      repeatInterval: data.repeat_interval,
      replaceMask: data.replace_mask,
      enabled: data.enabled,
      nextExportDt: data.next_export_dt,
    };

    return this.props.post(sendData);
  };

  public render() {
    const { data, isNew, className } = this.props;

    if (!data && !isNew) {
      return null;
    }

    const initialValues = isNew ? newInitialData : data;

    return (
      <Form
        className={className}
        initialValues={initialValues}
        data={initialValues}
        enableReinitialize
        onSubmit={this.onSubmit}
      />
    );
  }
}

export default connect<ConnectedState, ConnectedDispatch, ConnectedProps>(
  (state, props) => {
    const values = redux.selectors.form(state, props.id);

    return { data: values };
  },
  { post: redux.actions.form.post },
)(FormContainer);
