import * as React from 'react';
import { connect } from 'react-redux';
import redux from '../../redux';
import List from '../List';
import Form from '../Form';
import css from './Layout.scss';

interface Props {
  id?: number | null;
  isNew: boolean;
  url: string;
  destroy: () => void;
}

class Layout extends React.Component<Props> {
  public componentWillMount() {
    this.props.destroy();
  }

  public render() {
    const { id, isNew, url } = this.props;

    return (
      <div className={css.b}>
        <List url={url} className={css.b__list} selectedId={id} />
        {(isNew || id) && <Form id={id} isNew={isNew} className={css.b__form} />}
      </div>
    );
  }
}

export default connect(
  null,
  { destroy: redux.actions.module.destroy },
)(Layout);
