import * as React from 'react';
import RouterButton from 'components/RouterButton';
import Button from '@crm/components/dist/lego2/Button';
import ListComponent from 'modules/adminPanel/components/List';
import cx from 'classnames';
import { connect } from 'react-redux';
import redux from '../../redux';
import { TemplateList } from '../../types';
import css from './List.scss';

interface Props {
  url: string;
  className: string;
  get: () => void;
  items: TemplateList[];
  selectedId?: number | null;
}

class List extends React.Component<Props> {
  public componentDidMount() {
    this.promise = this.props.get();
  }

  public componentWillUnmount() {
    if (this.promise) {
      this.promise.cancel();
    }
  }

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  private promise?: any;

  public render() {
    const { items, className, url, selectedId } = this.props;

    return (
      <div className={cx(css.b, className)}>
        <div className={css.b__header}>
          <RouterButton to={`${url}/new`}>Создать</RouterButton>
          <Button
            className={css.b__help}
            view="link"
            type="link"
            url="https://st.yandex-team.ru/CRM-5064#1466410652000"
            target="_blank"
          >
            Справка
          </Button>
        </div>
        <ListComponent items={items} url={url} className={css.b__list} selectedId={selectedId} />
      </div>
    );
  }
}

export default connect((state) => ({ items: redux.selectors.items(state) }), {
  get: redux.actions.list.get,
})(List);
