import { push } from 'modules/notificationsUI/actions';

export default ({ actionTypes }) => {
  const actions = {
    module: {
      destroy: () => ({ type: actionTypes.module.DESTROY }),
    },
    list: {
      get() {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.list.get.REQUEST,
            actionTypes.list.get.RECEIVE,
            actionTypes.list.get.FAIL,
          ],
          args: {
            url: '/admin/exportstat/list',
            type: 'GET',
          },
        };
      },
    },
    form: {
      destroy: () => ({ type: actionTypes.form.DESTROY }),
      post(data) {
        return dispatch => {
          dispatch({
            type: 'FETCH',
            json: true,
            actions: [actionTypes.form.post.REQUEST, null, actionTypes.form.post.FAIL],
            args: {
              url: '/admin/exportstat/update',
              type: 'POST',
              data,
            },
          }).then(responseData => {
            dispatch(
              push({
                theme: 'success',
                text: responseData.message,
              }),
            );
            dispatch(actions.list.get());
            return responseData;
          });
        };
      },
    },
  };

  return actions;
};
