import { combineReducers } from 'redux';
import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';

export default actionTypes => {
  const list = {
    [actionTypes.list.get.REQUEST](state) {
      return {
        ...state,
        isFetch: true,
      };
    },
    [actionTypes.list.get.RECEIVE](state, { data }) {
      return {
        ...state,
        data,
        isLoad: true,
        isFetch: false,
      };
    },
    [actionTypes.list.get.FAIL](state) {
      return {
        ...state,
        isFetch: false,
      };
    },
  };

  return (state, action) => {
    if (action.type === actionTypes.module.DESTROY) {
      return {};
    }

    return combineReducers({
      list: reducerFactoryRaw(actionTypes, list, null),
    })(state, action);
  };
};
