import * as React from 'react';
import { Route } from 'react-router-dom';
import TitleChain from 'modules/heading';
import Layout from './components/Layout';

const TemplateModuleRouter = props => {
  const { match } = props;

  return (
    <React.Fragment>
      <TitleChain>Statface</TitleChain>
      <Route
        path={`${match.url}/:id?`}
        render={routerProps => <Layout {...routerProps} baseUrl={match.url} />}
      />
    </React.Fragment>
  );
};

export default TemplateModuleRouter;
