import * as React from 'react';
import { observer } from 'mobx-react-lite';
import { Route, Switch, RouteComponentProps } from 'react-router-dom';
import IFrame from './components/IFrame';
import PageRules from './modules/rules';
import PageLog from './components/PageLog';
import { SystemService } from './System.service';

const components = {
  PageRules,
  PageLog,
};

export const SystemRouter = observer(({ match }: RouteComponentProps) => {
  const modules = SystemService.getInstance().modules;

  return (
    <Switch>
      {modules.list.map((key) => {
        const item = modules.map[key];
        const routeProps: { [key: string]: unknown } = {};
        routeProps.path = `${match.path}/${key}`;

        if ('component' in item) {
          routeProps.component = components[item.component];
        } else {
          routeProps.render = () => <IFrame title={item.ru} src={item.url} />;
        }

        return <Route key={routeProps.path as string} {...routeProps} />;
      })}
    </Switch>
  );
});
