import { makeAutoObservable } from 'mobx';
import { logger } from 'services/Logger';
import { config } from 'services/Config';
import { get } from 'api/common';
import { SystemModules, BunkerModule } from './System.types';

export class SystemService {
  static getInstance(): SystemService {
    if (!SystemService.instance) {
      SystemService.instance = new SystemService();
      SystemService.instance.loadModules();
    }

    return SystemService.instance;
  }

  private static instance: SystemService | null = null;

  public isLoaded = false;
  public isPending = false;

  private _modules: SystemModules = {
    map: {
      rules_other_edit: {
        ru: 'Редактировать другие правила',
        component: 'PageRules',
      },
      log: {
        ru: 'Логи',
        component: 'PageLog',
      },
    },
    list: ['rules_other_edit', 'log'],
  };

  constructor() {
    makeAutoObservable(this);
  }

  get modules(): SystemModules {
    return this._modules;
  }

  async loadModules() {
    this.isPending = true;

    try {
      (await get<BunkerModule[]>({ url: '/v0/bunker/cat?node=admin-panel' })).forEach((module) => {
        this._modules.map[module.name] = {
          ru: module.title,
          url: `${config.value.backendAdminPanelHost}${module.url}`,
        };

        this._modules.list.push(module.name);
      });

      this.isLoaded = true;
    } catch (error) {
      logger.reportAppErrorOnly(error);
    }
    this.isPending = false;
  }
}
