import * as React from 'react';
import cx from 'classnames';
import css from './IFrame.scss';

interface Props {
  className?: string;
  title: string;
  src: string;
}

const IFrame = ({ title, src, className }: Props) => {
  return <iframe className={cx(css.b, className)} title={title} src={src} />;
};

export default IFrame;
