import React from 'react';
import { observer } from 'mobx-react-lite';
import { AdminNavGroup } from 'modules/adminPanel/components/AdminNavGroup';
import InvalidateCache from 'modules/adminPanel/components/InvalidateCache';
import { AdminNavLink } from 'modules/adminPanel/components/AdminNavLink';
import { SystemService } from '../../System.service';
import css from './NavBlock.module.css';
import { NavBlockProps } from './NavBlock.types';

export const NavBlock = observer(({ url }: NavBlockProps) => {
  const service = SystemService.getInstance();

  if (!service.isLoaded) {
    return null;
  }

  const modules = service.modules;

  return (
    <>
      <AdminNavGroup title="Системные">
        {modules.list.map((key) => (
          <AdminNavLink key={key} to={`${url}/${key}`}>
            {modules.map[key].ru}
          </AdminNavLink>
        ))}
      </AdminNavGroup>
      <div className={css.NavBlock__invalidateButton}>
        <InvalidateCache />
      </div>
    </>
  );
});
