import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import CopyButton from 'lego/components/CopyButton';
import TextInput from '@crm/components/dist/lego2/Textinput';
import { useMemo, useEffect, useState } from 'react';
import IFrame from '../IFrame';
import css from './PageLog.scss';
import { logTypes } from './PageLog.config';
import { State, Props } from './PageLog.types';
import { getState } from './PageLog.utils';

const onSubmit = (e) => e.preventDefault();

export const PageLog: React.FC<Props> = ({ location, history }) => {
  const state = useMemo<State>(() => getState(location.search), [location.search]);
  const [value, setValue] = useState(state.value || '');

  useEffect(() => {
    if (state.value) setValue(state.value);
  }, [state]);

  const handleClick = (logType: string) => {
    history.push(`?${logType}=${value}`);
  };

  return (
    <div className={css.b}>
      <form className={css.b__fields} onSubmit={onSubmit}>
        <TextInput
          className={css.PageLog__input}
          placeholder="id"
          autoFocus
          value={value}
          onChange={setValue}
        />

        {logTypes.map((logType, index) => (
          <Button
            className={css.b__button}
            onClick={() => handleClick(logType.name)}
            key={index}
            type={index === 0 ? 'submit' : undefined}
          >
            {logType.title}
          </Button>
        ))}

        <CopyButton className={css.b__button} copy={state.src!} />
      </form>
      {state.src && <IFrame title="Лог" src={state.src} />}
    </div>
  );
};

export default PageLog;
