import { State } from './PageLog.types';
import { logTypes } from './PageLog.config';

export const format = (url: string, value: string): string => url.replace(/%s/g, value);

export const getState = (search: string): State => {
  const params = new URLSearchParams(search);
  const logType = logTypes.find(({ name }) => params.has(name));
  if (!logType) {
    return {};
  }
  const value = params.get(logType.name)!;
  const src = `${document.location.origin}${format(logType.url, value)}`;
  return { value, src };
};
