import * as React from 'react';
import { observer } from 'mobx-react-lite';
import cx from 'classnames';
import Link from '@crm/components/dist/lego2/Link';
import Button from '@crm/components/dist/lego2/Button';
import { Overlay } from 'components/Overlay';
import css from './RulesEditor.module.css';
import { RulesEditorProps } from './RulesEditor.types';

import RuleService from '../../services/RuleService';

export const RulesEditor: React.FC<RulesEditorProps> = observer(({ rule, className }) => {
  const ruleService = React.useMemo(() => new RuleService(rule), [rule]);

  const handleTextChange = React.useCallback(
    (event) => {
      ruleService.setRuleText(event.target.value);
    },
    [ruleService],
  );

  return (
    <div className={cx(className, css.RulesEditor)}>
      {ruleService.isLoading ? <Overlay display hasSpinner zIndex={1} /> : null}

      <div className={css.RulesEditor__controls}>
        <Button
          className={css.RulesEditor__button}
          onClick={ruleService.save}
          disabled={ruleService.isLoading}
          progress={ruleService.isLoading}
        >
          Сохранить
        </Button>
        <Link href={`/space/admin/view/mrule?name=${rule}`} target="_blank">
          Открыть в html формате
        </Link>
      </div>

      <textarea
        className={css.RulesEditor__textarea}
        value={ruleService.ruleText}
        onChange={handleTextChange}
        spellCheck={false}
      />

      <pre className={css.RulesEditor__log}>
        {ruleService.response?.result} {ruleService.response?.message}
      </pre>
    </div>
  );
});
