import * as React from 'react';
import { RouteComponentProps, Route } from 'react-router-dom';

import VerticalNavigationMenu from 'components/VerticalNavigationMenu';
import RulesEditor from '../RulesEditor';

import { rules } from './RulesLayout.config';
import css from './RulesLayout.module.css';

export const RulesLayout: React.FC<RouteComponentProps> = ({ match }) => {
  return (
    <div className={css.RulesLayout}>
      <VerticalNavigationMenu className={css.RulesLayout__list} match={match} items={rules} />
      <Route
        path={`${match.url}/:rule`}
        component={({ match }) => (
          <RulesEditor className={css.RulesLayout__editor} rule={match.params.rule} />
        )}
      />
    </div>
  );
};
