import { makeAutoObservable } from 'mobx';
import { get, post } from 'api/common';

import { RulesStore } from './RuleService.types';

export class RuleService implements RulesStore {
  ruleName = '';
  ruleText = '';
  response;
  isLoading = false;

  constructor(ruleName) {
    makeAutoObservable<RulesStore>(this);
    this.ruleName = ruleName;
    this.load();
  }

  setRuleText = (value: string) => {
    this.ruleText = value;
  };

  save = () => {
    this.isLoading = true;
    post({
      url: '/admin/actions/mrule/update',
      data: {
        Name: this.ruleName,
        Rules: this.ruleText,
      },
    })
      .then((response) => {
        this.response = response;
      })
      .finally(() => {
        this.isLoading = false;
      });
  };

  private load = async () => {
    this.isLoading = true;
    const htmlString = await get<string>({
      url: `/admin/view/mrule`,
      data: { name: this.ruleName },
    });

    this.isLoading = false;

    const dom = this.parseHtml(htmlString);
    const rule = dom.body.textContent || '';

    this.setRuleText(rule.trim());
  };

  private parseHtml(html: string) {
    const parser = new DOMParser();
    return parser.parseFromString(html, 'text/html');
  }
}
