import React, { useCallback, ComponentType } from 'react';
import { FieldRenderProps } from 'react-final-form';
import { AnyObject } from 'final-form';

export const CastValueToNumber = (
  props: FieldRenderProps<number> & { renderAs: ComponentType<AnyObject> },
) => {
  const { renderAs: Component } = props;
  const { onChange, name, value, type } = props.input;

  const handleChange = useCallback(
    (numberText: string) => {
      onChange(Number(numberText));
    },
    [onChange],
  );

  return <Component value={value} onChange={handleChange} name={name} type={type} {...props} />;
};
