import React, { PureComponent, ReactNode } from 'react';
import { Field } from 'react-final-form';
import Select from '@crm/components/dist/lego2/Select';
import Textinput from '@crm/components/dist/lego2/Textinput';
import { Option } from '@yandex-lego/components/Select';
import memoize from 'memoize-one';
import { QueueOptionProps } from './QueueOption.types';
import { unitToOption } from './QueueOption.utils';
import css from './QueueOption.module.css';
import { YaCallsUnit } from '../types';
import QueueName from './QueueName';
import { CastValueToNumber } from './CastValueToNumber';

class QueueOption extends PureComponent<QueueOptionProps> {
  private mapUnitsToOptions = memoize((units: YaCallsUnit[] | undefined): Option[] | undefined => {
    if (units) {
      return units.map(unitToOption);
    }
    return units;
  });

  public render(): ReactNode {
    const { style, name, units } = this.props;
    const unitOptions = this.mapUnitsToOptions(units);

    return (
      <div className={css.QueueOption} style={style}>
        <Field name={`${name}.queueName`} render={QueueName} />
        <div className={css.QueueOption__unit}>
          {unitOptions ? (
            <Field
              component={CastValueToNumber}
              renderAs={Select}
              name={`${name}.unitId`}
              options={unitOptions}
            />
          ) : (
            'Нет доступных юнитов'
          )}
        </div>
        <div className={css.QueueOption__duration}>
          <Field
            component={CastValueToNumber}
            renderAs={Textinput}
            name={`${name}.acwDuration`}
            type="number"
            hasClear={false}
          />
        </div>
      </div>
    );
  }
}

export default QueueOption;
