export interface QueueOption {
  queueId: number; // идентификатор очереди
  queueName: string; // название очереди
  queueCode: string; // код очереди
  unitId: number | 0; // идентификатор юнита в нашей БД (0 - юнит не задан)
  acwDuration: number | 0; // длительность постколла в секнудах (9 - длительность не задана)
}

export interface YaCallsUnit {
  id: number; // "name": имя юнита
  name: string; // "id": идентификатор юнита в нашей БД для связи с unitId
}

export type QueueMap = Record<number, QueueOption>;

export interface FormValues {
  queueMap: QueueMap;
}
