import * as React from 'react';
import { reduxForm, FieldArray, InjectedFormProps } from 'redux-form';
import { FormattedDate } from 'react-intl';
import Row from 'forms/Base/Row';
import FieldWrap from 'forms/Base/Row/FieldWrap';
import Form from 'components/Form';
import Toolbar from 'components/Toolbar';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import Queues from './Queues';
import Grants from './Grants';
import constants from '../../constants';
import css from './Form.scss';

interface Data {
  id?: number;
  modifiedOn?: string;
  modifierName?: string;
}

interface Props {
  className?: string;
  data: Data;
  meta?: any;
}

const TemplateForm: React.FC<Props & InjectedFormProps<Data, Props>> = ({
  handleSubmit,
  className,
  initialValues,
  data,
  submitting,
  invalid,
}) => (
  <Form className={cx(className, css.b)} onSubmit={handleSubmit}>
    <div className={css.b__header}>
      <Toolbar inline>
        <Button view="action" type="submit" disabled={submitting || invalid}>
          Сохранить
        </Button>
      </Toolbar>
      {data.id && (
        <div className={css.b__meta}>
          <div className={css.b__field}>
            <span className={css.b__label}>id:</span>
            <span className={css.b__value}>{data.id}</span>
            &nbsp;
          </div>
          {data.modifiedOn && (
            <div className={css.b__field}>
              <span className={css.b__label}>Последнее изменение:</span>
              <span className={css.b__value}>
                {data.modifierName && (
                  <React.Fragment>
                    <span>{data.modifierName}</span>
                    ,&nbsp;
                  </React.Fragment>
                )}
                <FormattedDate
                  value={new Date(data.modifiedOn)}
                  year="numeric"
                  month="numeric"
                  day="numeric"
                  hour="numeric"
                  minute="numeric"
                />
              </span>
              &nbsp;
            </div>
          )}
        </div>
      )}
    </div>
    <div className={css.b__content}>
      <Row label="Название" component="TextInput" name="name" />
      <Row
        label="BodyHtml"
        name="bodyHtml"
        component="RichTextEditor"
        theme="inline"
        enableReinitialize
      />
      <Row
        label="BodyPlain"
        name="bodyPlain"
        component="RichTextEditor"
        startupMode="source"
        theme="inline"
        enableReinitialize
      />
      <Row
        label="Файлы"
        name="files"
        component="AttachFiles"
        objId={initialValues.id}
        objectName="template"
      />
      <FieldWrap label="Почтовый клиент">
        <FieldArray name="queueTemplateRows" component={Queues as any} size="xs" />
      </FieldWrap>
      <FieldWrap label="Доступы">
        <FieldArray name="grants" component={Grants as any} size="xs" />
      </FieldWrap>
    </div>
  </Form>
);

TemplateForm.defaultProps = {
  meta: {},
  initialValues: {},
};

export default reduxForm<Data, Props>({ form: constants.name })(TemplateForm);
