import * as React from 'react';
import { connect } from 'react-redux';
import Form from './Form';
import redux from '../../redux';

interface Props {
  id?: number | null;
  isNew?: boolean;
  className?: string;
  get: (id: number) => void;
  post: (values: any) => any;
  data: any;
}

const newInitialData = {
  bodyPlain: '',
  bodyHtml: '',
};

class FormContainer extends React.PureComponent<Props> {
  public componentDidMount() {
    if (this.props.id) {
      this.props.get(this.props.id);
    }
  }

  public componentDidUpdate(prevProps) {
    const currentId = this.props.id;
    const lastId = prevProps.id;

    if (currentId !== lastId && Number.isInteger(currentId as number)) {
      this.props.get(currentId as number);
    }
  }

  private onSubmit = data => {
    const sendData = {
      templateId: data.id,
      name: data.name,
      bodyPlain: data.bodyPlain,
      bodyHtml: data.bodyHtml,
      queueRows: data.queueTemplateRows,
      grants: data.grants,
      containerId: data.containerId,
    };

    return this.props.post(sendData);
  };

  public render() {
    const { data, isNew, className } = this.props;

    if (!data && !isNew) {
      return null;
    }

    const initialValues = isNew ? newInitialData : data;

    return (
      <Form
        className={className}
        initialValues={initialValues}
        data={initialValues}
        enableReinitialize
        onSubmit={this.onSubmit}
      />
    );
  }
}

export default connect(
  state => {
    const values = redux.selectors.form(state) || {};

    return { data: values.data, isFetch: values.isFetch, isLoad: values.isLoad };
  },
  { get: redux.actions.form.get, post: redux.actions.form.post },
)(FormContainer);
