import * as React from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { Field, getFormValues } from 'redux-form';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import TextInput from 'lego/redux-form/TextInput';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import CheckBox from 'lego/redux-form/CheckBox';
import css from './TableInput.scss';

const NewRow = {
  id: null,
  userLogin: null,
  groupUrl: null,
  r: 0,
  w: 0,
  d: 0,
  removed: false,
  editable: true,
};

interface ConnectedState {
  disabled: boolean;
}

interface ConnectedProps {
  form: string;
  path: string;
  size?: string;
}

type Props = ConnectedState & ConnectedProps;

const GrantRow: React.FC<Props> = (props) => {
  const { path, disabled, size } = props;

  return (
    <div className={css.b__row}>
      <span>
        <Field name={`${path}.userLogin`} component={TextInput} disabled={disabled} size={size} />
      </span>
      <span>
        <Field name={`${path}.groupUrl`} component={TextInput} disabled={disabled} size={size} />
      </span>
      <span>
        <Field
          name={`${path}.r`}
          component={TextInput}
          hasClear={!disabled}
          disabled={disabled}
          size={size}
        />
      </span>
      <span>
        <Field
          name={`${path}.w`}
          component={TextInput}
          hasClear={!disabled}
          disabled={disabled}
          size={size}
        />
      </span>
      <span>
        <Field
          name={`${path}.d`}
          component={TextInput}
          hasClear={!disabled}
          disabled={disabled}
          size={size}
        />
      </span>
      <span>
        <Field name={`${path}.removed`} component={CheckBox} />
      </span>
    </div>
  );
};

const ConnectQueueRow = connect<ConnectedState, {}, ConnectedProps>((state, props) => ({
  disabled: !get(getFormValues(props.form)(state), `${props.path}.editable`),
}))(GrantRow);

type RenderGrants = (props: { fields: any; meta: any; size: LegoSizeProp }) => React.ReactNode;
const RenderGrants: RenderGrants = ({ fields, meta, size }) => (
  <div className={cx(css.b, css.b_grants)}>
    <div className={css.b__content}>
      <div className={cx(css.b__row, css.b__row_header)}>
        <span>UserLogin</span>
        <span>GroupUrl</span>
        <span>Read</span>
        <span>Write</span>
        <span>Delete</span>
        <span>Удалить</span>
      </div>
      {fields.map((path, index) => (
        // eslint-disable-next-line react/no-array-index-key
        <ConnectQueueRow form={meta.form} path={path} key={index} size={size} />
      ))}
    </div>
    <div className={css.b__footer}>
      <Button onClick={() => fields.push(NewRow)} size={size}>
        Добавить
      </Button>
    </div>
  </div>
);

export default RenderGrants;
