/*
eslint-disable react/no-array-index-key
*/

import * as React from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { Field, getFormValues } from 'redux-form';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import TextInput from 'lego/redux-form/TextInput';
import CheckBox from 'lego/redux-form/CheckBox';
import css from './TableInput.scss';

const NewRow = {
  id: null,
  queueId: null,
  categoryId: null,
  targetId: null,
  removed: false,
  editable: true,
};

interface Props {
  path: string;
  size?: string;
  form: string;
}

interface QueueRowProps extends Props {
  disabled: boolean;
}

const QueueRow = (props: QueueRowProps): React.ReactNode => {
  const { path, disabled, size } = props;

  return (
    <div className={css.b__row}>
      <span>
        <Field name={`${path}.queueId`} component={TextInput} disabled={!disabled} size={size} />
      </span>
      <span>
        <Field name={`${path}.categoryId`} component={TextInput} disabled={!disabled} size={size} />
      </span>
      <span>
        <Field name={`${path}.targetId`} component={TextInput} disabled={!disabled} size={size} />
      </span>
      <span>
        <Field name={`${path}.removed`} component={CheckBox} />
      </span>
    </div>
  );
};

interface StateProps {
  disabled: boolean;
}

const ConnectQueueRow = connect<StateProps, null, Props>(
  (state, props): StateProps => ({
    disabled: Boolean(get(getFormValues(props.form)(state), `${props.path}.editable`)),
  }),
)(QueueRow as any);

interface RenderQueueProps {
  fields: any;
  meta: any;
  size?: LegoSizeProp;
}

type RenderQueue = (props: RenderQueueProps) => React.ReactNode;
const RenderQueue: RenderQueue = ({ fields, meta, size }) => (
  <div className={css.b}>
    <div className={css.b__content}>
      <div className={cx(css.b__row, css.b__row_header)}>
        <span>QueueId</span>
        <span>CategoryId</span>
        <span>TargetId</span>
        <span>Удалить</span>
      </div>
      {fields.map((path, index) => (
        <ConnectQueueRow form={meta.form} path={path} key={index} size={size} />
      ))}
    </div>
    <div className={css.b__footer}>
      <Button onClick={(): void => fields.push(NewRow)} size={size}>
        Добавить
      </Button>
    </div>
  </div>
);

export default RenderQueue;
