import * as React from 'react';
import * as ReactRouterDom from 'react-router-dom';
import Layout from './Layout';

interface Param {
  id?: string;
}

interface Props {
  baseUrl: string;
  match: ReactRouterDom.match<Param>;
}

const LayoutRouter: React.FC<Props> = props => {
  const { match, baseUrl } = props;
  const { id } = match.params;
  const parsedId = parseInt(id as string, 10) || null;
  const isNew = id === 'new';

  return <Layout url={baseUrl} id={parsedId} isNew={isNew} />;
};

export default LayoutRouter;
