import * as React from 'react';
import RouterButton from 'components/RouterButton';
import ListComponent from 'modules/adminPanel/components/List';
import cx from 'classnames';
import { connect } from 'react-redux';
import TextInput from '@crm/components/dist/lego2/Textinput';
import redux from '../../redux';
import { GroupTemplates } from '../../types';
import css from './List.scss';

interface Props {
  url: string;
  className: string;
  get: () => void;
  groups: GroupTemplates[];
  selectedId?: number | null;
}

interface State {
  search: string;
}

class List extends React.Component<Props, State> {
  state = {
    search: '',
  };

  public componentDidMount() {
    this.promise = this.props.get();
  }

  public componentWillUnmount() {
    if (this.promise) {
      this.promise.cancel();
    }
  }

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  private promise: any;

  private onChange = (search: string) => {
    this.setState({ search });
  };

  public render() {
    const { groups, className, url, selectedId } = this.props;

    return (
      <div className={cx(css.b, className)}>
        <div className={css.b__header}>
          <RouterButton to={`${url}/new`}>Создать шаблон</RouterButton>
          <TextInput placeholder="Поиск" value={this.state.search} onChange={this.onChange} />
        </div>
        <ListComponent
          items={groups}
          url={url}
          className={css.b__list}
          selectedId={selectedId}
          search={this.state.search}
          groups
        />
      </div>
    );
  }
}

export default connect((state) => ({ groups: redux.selectors.groups(state) }), {
  get: redux.actions.list.get,
})(List);
