import { push } from 'modules/notificationsUI/actions';

export default ({ actionTypes }) => {
  const actions = {
    module: {
      destroy: () => ({ type: actionTypes.module.DESTROY }),
    },
    list: {
      get() {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.list.get.REQUEST,
            actionTypes.list.get.RECEIVE,
            actionTypes.list.get.FAIL,
          ],
          args: {
            url: '/admin/template/list',
            type: 'GET',
          },
        };
      },
    },
    form: {
      destroy: () => ({ type: actionTypes.form.DESTROY }),
      get(id) {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.form.get.REQUEST,
            actionTypes.form.get.RECEIVE,
            actionTypes.form.get.FAIL,
          ],
          promiseCallback: promise => {
            return promise.then(data => {
              const formattedData = {
                ...data,
              };

              if (Array.isArray(formattedData.grants)) {
                formattedData.grants = formattedData.grants.map(grant => {
                  if (!grant) {
                    return grant;
                  }

                  const result = { ...grant };
                  result.r = grant.read;
                  result.w = grant.write;
                  result.d = grant.delete;

                  return result;
                });
              }

              return formattedData;
            });
          },
          args: {
            url: '/admin/template',
            data: {
              templateId: id,
            },
            type: 'GET',
          },
        };
      },
      post(data) {
        return dispatch => {
          dispatch({
            type: 'FETCH',
            json: true,
            actions: [actionTypes.form.post.REQUEST, null, actionTypes.form.post.FAIL],
            args: {
              url: '/admin/template/update',
              type: 'POST',
              data,
            },
          }).then(responseData => {
            dispatch(
              push({
                theme: 'success',
                text: responseData.message,
              }),
            );
            if (data.templateId) {
              dispatch(actions.form.get(data.templateId));
            }
            dispatch(actions.list.get());
            return responseData;
          });
        };
      },
    },
  };

  return actions;
};
