import React from 'react';
import { Form } from 'react-final-form';
import Button from '@crm/components/dist/lego2/Button';
import { observer } from 'mobx-react-lite';
import { Text } from '@crm/components/dist/lego2/Text';
import css from './Layout.module.css';
import { Units } from './Units';
import { UnitsService } from '../UnitsService';

export const Layout = observer(() => {
  const unitsService = React.useMemo(() => new UnitsService(), []);
  const handleSubmit = (values) => unitsService.save(values);

  return (
    <div className={css.Layout}>
      <Form onSubmit={handleSubmit} initialValues={unitsService.initialValues}>
        {(props) => (
          <form onSubmit={props.handleSubmit} className={css.Layout__form}>
            <div className={css.Layout__header}>
              <Text>Юнит</Text>
              <Text>Тип юнита</Text>
            </div>

            <Units unitsService={unitsService} />

            <div className={css.Layout__toolbar}>
              <Button view="action" type="submit" disabled={props.submitting || props.pristine}>
                Сохранить
              </Button>
            </div>
          </form>
        )}
      </Form>
    </div>
  );
});
