import React from 'react';
import { Field } from 'react-final-form';
import Select from 'lego/final-form/Select';
import { observer } from 'mobx-react-lite';
import { Text } from '@crm/components/dist/lego2/Text';
import css from './Units.module.css';
import { getFieldNameFromId } from '../../UnitsService/UnitsService.utils';
import { UnitsProps } from './Units.types';
import { UnitKindOptions } from './Units.constants';

export const Units: React.FC<UnitsProps> = observer(({ unitsService }) => {
  return (
    <div className={css.Units}>
      {unitsService.units.map((unit) => (
        <div key={unit.id} className={css.Units__unit}>
          <Text>{unit.name}</Text>

          <div className={css.Units__type}>
            <Field
              component={Select}
              name={getFieldNameFromId(unit.id)}
              hasEmptyValue={false}
              options={UnitKindOptions}
            />
            <Field name={getFieldNameFromId(unit.id)}>
              {({ meta }) => (
                <Text typography="control-xs" color="control-error" className={css.Units__error}>
                  {meta.submitError}
                </Text>
              )}
            </Field>
          </div>
        </div>
      ))}
    </div>
  );
});
