import { YaCallsUnitKind } from 'types/YaCallsUnitKind';
import { Message } from 'types/Message/Message';

export interface Unit {
  id: number;
  name: string;
  kind: YaCallsUnitKind;
}

export type UnitsFormValues = Record<string, YaCallsUnitKind>;

export interface ToggleResult {
  error: string;
  units: number[];
}

export interface BatchToggleIsPersonalResponse {
  messages: Message[];
  toggleResults: ToggleResult[];
}

export interface BatchToggleIsPersonalRequest {
  switches: {
    unitId: number;
    isPersonal: boolean;
  }[];
}
