import { YaCallsUnitKind } from 'types/YaCallsUnitKind';
import { UnitsFormValues, ToggleResult } from './UnitsService.types';

export const getFieldNameFromId = (id) => `unit:${id}`;
export const getIdFromFieldName = (name: string) => Number(name.split(':')[1]);

export const mapErrors = (errors: ToggleResult[]) => {
  const result: Record<string, string> = {};

  for (const { error, units } of errors) {
    for (const id of units) {
      result[getFieldNameFromId(id)] = error;
    }
  }

  return result;
};

export const mapFormValuesToApi = (values: UnitsFormValues) => {
  return Object.keys(values).map((key) => ({
    unitId: getIdFromFieldName(key),
    isPersonal: Number(values[key]) === YaCallsUnitKind.Personal,
  }));
};
